'
' This class implements AveragingSensor operations for sensors made
' by Hawk.
'
Public Class HawkAveragingSensor
    Inherits HawkSimpleSensor
    Implements AveragingSensorImpl

    '
    ' Averaging sensors produce a value that is the average of
    ' measurements made over a period of time.  That period of time
    ' begins when this method is called.
    ' The method may throw <see cref="SensorException"/>
    ' if there is a problem accessing the sensor.
    '
    Public Sub BeginAverage() _
    Implements AveragingSensorImpl.BeginAverage
        oldValue = MyBase.CurrentMeasure ' set an initial value
    End Sub

    Private oldValue As Integer ' instance variable to contain running avg

    '
    ' average the new values with previous values
    '
    Public Overrides ReadOnly Property CurrentMeasure() As Integer
        Get
            oldValue = (oldValue + MyBase.CurrentMeasure) \ 2
            Return oldValue
        End Get
    End Property
End Class 'HawkAveragingSensor 
